import glob


def read_charge_density(filename):
    with open(filename, 'r') as file:
        lines = file.readlines()

    # 读取 FFT 网格大小
    fft_grid_info = lines[3:6]
    grid_points = 1
    voxel_volume = 1.0
    for i in range(3):
        parts = fft_grid_info[i].split()
        grid_points *= int(parts[0])  # 网格点数乘积
        voxel_volume *= float(parts[i+1])  # 计算体元体积

    # 读取电荷密度值
    density_values = []
    for line in lines[8:]:
        density_values.extend([float(x) for x in line.split()])

    if len(density_values) != grid_points:
        raise ValueError("电荷密度值数量与FFT网格大小不匹配。")

    # 计算电荷密度积分
    total_electrons = sum(density_values) * voxel_volume
    return total_electrons


def process_charge_densities(basis_type):
    directory = "./OUT.ABACUS/"
    if basis_type == 'pw':
        file_pattern = "band*.cube"
    elif basis_type == 'lcao':
        file_pattern = "BAND*_SPIN0_CHG.cube"
    else:
        raise ValueError("未知的基组类型")

    for file_path in sorted(glob.glob(directory + file_pattern)):
        density_integral = read_charge_density(file_path)
        print(f"电荷密度积分：{file_path.split('/')[-1]}", density_integral)


# process_charge_densities('lcao')
process_charge_densities('pw')
