#!/bin/bash

if [ -z "$CBMC_DIR" ]
then
    echo "Please export CBMC_DIR!"
    exit 1
fi

GOCC="$CBMC_DIR/src/goto-cc/goto-cc"

BASE="$(basename -s .sh $0)"

$GOCC $BASE.c -o $BASE.o

$CBMC_DIR/src/goto-instrument/goto-instrument \
    --dump-c \
    --use-system-headers \
    $BASE.o \
    $BASE.inst.i

if ! gcc $BASE.c
then
    echo "GCC failed!"
    exit 1
fi

if grep -q "typedef const" $BASE.inst.i
then
    echo "The def of type uint32_t should not be const!"
    exit 1
fi

echo "OK!"
