#include "ntlm.h"
#include <string.h>

static uint8_t s_key_exchange_key[] = { 0xde, 0xae, 0x3b, 0x3c, 0x49, 0xc2, 0x4b, 0x75, 0x5e, 0x97, 0xe3, 0xb5, 0xb8, 0x9c, 0xfd, 0x6f };
static uint8_t s_enc_sess_key[] = { 0x8a, 0xca, 0x9f, 0x81, 0x89, 0x96, 0x39, 0xc8, 0x8c, 0xb9, 0xc9, 0x35, 0x86, 0x8c, 0x25, 0x8e };

static uint8_t s_auth_msg[] = "\x4e\x54\x4c\x4d\x53\x53\x50\x00\x03\x00\x00\x00\x18\x00\x18\x00" \
			"\x98\x00\x00\x00\xd0\x00\xd0\x00\xb0\x00\x00\x00\x12\x00\x12\x00" \
			"\x58\x00\x00\x00\x10\x00\x10\x00\x6a\x00\x00\x00\x1e\x00\x1e\x00" \
			"\x7a\x00\x00\x00\x10\x00\x10\x00\x80\x01\x00\x00\x35\x82\x88\xe2" \
			"\x0a\x00\x61\x4a\x00\x00\x00\x0f\xfa\xc6\x22\x54\x45\x1a\xa8\x31" \
			"\xd2\xaf\xf5\x4f\x21\x21\x9e\x2e\x54\x00\x45\x00\x53\x00\x54\x00" \
			"\x2e\x00\x41\x00\x44\x00\x4c\x00\x50\x00\x74\x00\x65\x00\x73\x00" \
			"\x74\x00\x75\x00\x73\x00\x65\x00\x72\x00\x53\x00\x45\x00\x52\x00" \
			"\x47\x00\x45\x00\x59\x00\x50\x00\x41\x00\x43\x00\x48\x00\x4b\x00" \
			"\x30\x00\x32\x00\x30\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
			"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
			"\x55\xef\xd5\xef\xa2\x25\x81\xf2\x09\x9a\x78\xdb\x3c\x30\x03\x24" \
			"\x01\x01\x00\x00\x00\x00\x00\x00\xd6\x94\x1f\x91\x96\x3b\xd9\x01" \
			"\x2b\x98\x70\xd5\x08\x5a\xe5\x8a\x00\x00\x00\x00\x01\x00\x0a\x00" \
			"\x41\x00\x4c\x00\x54\x00\x30\x00\x31\x00\x02\x00\x08\x00\x54\x00" \
			"\x45\x00\x53\x00\x54\x00\x03\x00\x1e\x00\x61\x00\x6c\x00\x74\x00" \
			"\x30\x00\x31\x00\x2e\x00\x74\x00\x65\x00\x73\x00\x74\x00\x2e\x00" \
			"\x61\x00\x64\x00\x6c\x00\x70\x00\x06\x00\x04\x00\x06\x00\x00\x00" \
			"\x07\x00\x08\x00\xd6\x94\x1f\x91\x96\x3b\xd9\x01\x08\x00\x30\x00" \
			"\x30\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x20\x00\x00" \
			"\xe1\xba\x94\x58\x31\xaa\xb4\x53\xb7\xc7\x8a\x7a\xba\x60\x3c\xd2" \
			"\x93\xfc\xd3\x31\x6f\x53\xbb\x4a\x27\xdf\xda\xb1\x9c\xc1\x60\x32" \
			"\x0a\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
			"\x00\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
			"\x8a\xca\x9f\x81\x89\x96\x39\xc8\x8c\xb9\xc9\x35\x86\x8c\x25\x8e" ;

static uint8_t s_chal_msg[] = "\x4e\x54\x4c\x4d\x53\x53\x50\x00\x02\x00\x00\x00\x08\x00\x08\x00" \
			"\x38\x00\x00\x00\x35\x82\x89\xe2\xd2\x95\xc0\x7a\xd1\x26\x73\x12" \
			"\x00\x00\x00\x00\x00\x00\x00\x00\x54\x00\x54\x00\x40\x00\x00\x00" \
			"\x06\x02\x00\x00\x00\x00\x00\x0f\x54\x00\x45\x00\x53\x00\x54\x00" \
			"\x01\x00\x0a\x00\x41\x00\x4c\x00\x54\x00\x30\x00\x31\x00\x02\x00" \
			"\x08\x00\x54\x00\x45\x00\x53\x00\x54\x00\x03\x00\x1e\x00\x61\x00" \
			"\x6c\x00\x74\x00\x30\x00\x31\x00\x2e\x00\x74\x00\x65\x00\x73\x00" \
			"\x74\x00\x2e\x00\x61\x00\x64\x00\x6c\x00\x70\x00\x06\x00\x04\x00" \
			"\x00\x00\x00\x00\x07\x00\x08\x00\xd6\x94\x1f\x91\x96\x3b\xd9\x01" \
			"\x00\x00\x00\x00" ;

static uint8_t s_nego_msg[] = "\x4e\x54\x4c\x4d\x53\x53\x50\x00\x01\x00\x00\x00\xb7\x82\x08\xe2" \
			"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
			"\x0a\x00\x61\x4a\x00\x00\x00\x0f" ;

static uint8_t s_micbuf[] = { 0xfa, 0xc6, 0x22, 0x54, 0x45, 0x1a, 0xa8, 0x31, 0xd2, 0xaf, 0xf5, 0x4f, 0x21, 0x21, 0x9e, 0x2e };

int main()
{
	struct ntlm_buffer nego_msg = { .data = s_nego_msg, .length = 40 };
	struct ntlm_buffer chal_msg = { .data = s_chal_msg, .length = 148 };
	struct ntlm_buffer auth_msg = { .data = s_auth_msg, .length = 400 };

	uint8_t server_chal[8];

	struct ntlm_key exported_session_key = { .length = 16 };

	uint64_t timestamp;
	struct ntlm_buffer enc_sess_key = { .data = s_enc_sess_key, .length = 16 };
	struct ntlm_key encrypted_random_session_key = { .length = 16 };
	struct ntlm_key key_exchange_key = { .length = 16 };

	memcpy(key_exchange_key.data, s_key_exchange_key, key_exchange_key.length );
	struct ntlm_buffer mic = { s_micbuf, 16 };

	memcpy(encrypted_random_session_key.data, enc_sess_key.data, 16);

	int retmin = ntlm_encrypted_session_key(&key_exchange_key,
			&encrypted_random_session_key,
			&exported_session_key);

	retmin = ntlm_verify_mic(&exported_session_key,
			&nego_msg, &chal_msg,
			&auth_msg, &mic);

	return 0;
}

