package test.mybatis;

import org.junit.jupiter.api.Test;
import org.mybatis.spring.boot.test.autoconfigure.MybatisTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

import static org.junit.jupiter.api.Assertions.assertNotNull;

@SpringJUnitConfig
@MybatisTest
public class FooMapperTest {
    @Autowired
    private FooMapper classUnderTest;

    @Test
    @Sql("/insert_foo.sql")
    void should_find_one(){
        Bar bar = new Bar();
        bar.setStr("Nice String");
        bar.setNum(23);
        Foo foo = new Foo(bar, "Fancy Name");

        assertNotNull(classUnderTest.find().getBar());
    }
}
