package com.example.mybatisbug;

import com.example.mybatisbug.dao.CityMapper;
import com.example.mybatisbug.pojo.City;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import java.time.LocalDateTime;

@SpringBootApplication
public class MybatisBugApplication implements CommandLineRunner {

    private final CityMapper cityMapper;

    public MybatisBugApplication(CityMapper cityMapper) {
        this.cityMapper = cityMapper;
    }

    public static void main(String[] args) {
        SpringApplication.run(MybatisBugApplication.class, args);
    }

    @Override
    public void run(String... args) throws Exception {
        City city = new City();
        city.setName("Kyiv");
        city.setCreated(LocalDateTime.now());

        this.cityMapper.insert(city);
        System.out.println("--> DB: " + city);
        System.out.println("<-- DB: " + this.cityMapper.findById(city.getId()));
    }
}
