import SwiftUI
import ComposableArchitecture

struct FullScreenCoverFeature: Reducer {
  @Dependency(\.dismiss) private var dismiss

  struct State: Equatable {}

  enum Action {
    case dismissButtonTapped
  }

  var body: some ReducerOf<Self> {
    Reduce { state, action in
      switch action {
      case .dismissButtonTapped:
        return .run { _ in await dismiss() }
      }
    }
  }
}

struct FullScreenCoverView: View {
  let store: StoreOf<FullScreenCoverFeature>

  var body: some View {
    VStack(alignment: .center) {
      Text("Full screen cover")
        .font(.title)
      Text("This screen should be presented as a full screen cover")
      Button("Dismiss") {
        store.send(.dismissButtonTapped)
      }
      .buttonStyle(.borderedProminent)
    }
    .multilineTextAlignment(.center)
  }
}
