import SwiftUI
import ComposableArchitecture

struct SheetFeature: Reducer {
  @Dependency(\.dismiss) private var dismiss

  struct State: Equatable {}

  enum Action {
    case dismissButtonTapped
  }

  var body: some ReducerOf<Self> {
    Reduce { state, action in
      switch action {
      case .dismissButtonTapped:
        return .run { _ in await dismiss() }
      }
    }
  }
}

struct SheetView: View {
  let store: StoreOf<SheetFeature>

  var body: some View {
    VStack(alignment: .center) {
      Text("Sheet").font(.title)
      Text("This screen should be presented as a sheet")
      Button("Dismiss then show full screen cover") {
        store.send(.dismissButtonTapped)
      }
      .buttonStyle(.borderedProminent)
    }
    .multilineTextAlignment(.center)
  }
}
