#![no_std]
#![no_main]

extern crate panic_itm;
use cortex_m::peripheral::syst::SystClkSource;
use cortex_m_rt::{entry};

extern "C" {
    fn DMA0();
    fn DMA1();
    fn DMA2();
    fn DMA3();
    fn DMA4();
    fn DMA5();
    fn DMA6();
    fn DMA7();
    fn DMA8();
    fn DMA9();
    fn DMA10();
    fn DMA11();
    fn DMA12();
    fn DMA13();
    fn DMA14();
    fn DMA15();
    fn DMA_ERROR();
    fn MCM();
    fn FTFA();
    fn READ_COLLISION();
    fn LVD_LVW();
    fn LLWU();
    fn WDOG_EWM();
    fn RNG();
    fn I2C0();
    fn I2C1();
    fn SPI0();
    fn SPI1();
    fn I2S0_TX();
    fn I2S0_RX();
    fn UART0_RX_TX();
    fn UART0_ERR();
    fn UART1_RX_TX();
    fn UART1_ERR();
    fn UART2_RX_TX();
    fn UART2_ERR();
    fn UART3_RX_TX();
    fn UART3_ERR();
    fn ADC0();
    fn CMP0();
    fn CMP1();
    fn FTM0();
    fn FTM1();
    fn FTM2();
    fn CMT();
    fn RTC();
    fn RTC_SECONDS();
    fn PIT0();
    fn PIT1();
    fn PIT2();
    fn PIT3();
    fn PDB0();
    fn USB0();
    fn USBDCD();
    fn DAC0();
    fn LPTMR0();
    fn PORTA();
    fn PORTB();
    fn PORTC();
    fn PORTD();
    fn PORTE();
    fn SPI2();
    fn UART4_RX_TX();
    fn UART4_ERR();
    fn UART5_RX_TX();
    fn UART5_ERR();
    fn FTM3();
    fn ADC1();
    fn I2C2();
}

pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}

#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 75] = [
    Vector { _handler: DMA0 },
    Vector { _handler: DMA1 },
    Vector { _handler: DMA2 },
    Vector { _handler: DMA3 },
    Vector { _handler: DMA4 },
    Vector { _handler: DMA5 },
    Vector { _handler: DMA6 },
    Vector { _handler: DMA7 },
    Vector { _handler: DMA8 },
    Vector { _handler: DMA9 },
    Vector { _handler: DMA10 },
    Vector { _handler: DMA11 },
    Vector { _handler: DMA12 },
    Vector { _handler: DMA13 },
    Vector { _handler: DMA14 },
    Vector { _handler: DMA15 },
    Vector {
        _handler: DMA_ERROR,
    },
    Vector { _handler: MCM },
    Vector { _handler: FTFA },
    Vector {
        _handler: READ_COLLISION,
    },
    Vector { _handler: LVD_LVW },
    Vector { _handler: LLWU },
    Vector { _handler: WDOG_EWM },
    Vector { _handler: RNG },
    Vector { _handler: I2C0 },
    Vector { _handler: I2C1 },
    Vector { _handler: SPI0 },
    Vector { _handler: SPI1 },
    Vector { _handler: I2S0_TX },
    Vector { _handler: I2S0_RX },
    Vector { _reserved: 0 },
    Vector {
        _handler: UART0_RX_TX,
    },
    Vector {
        _handler: UART0_ERR,
    },
    Vector {
        _handler: UART1_RX_TX,
    },
    Vector {
        _handler: UART1_ERR,
    },
    Vector {
        _handler: UART2_RX_TX,
    },
    Vector {
        _handler: UART2_ERR,
    },
    Vector {
        _handler: UART3_RX_TX,
    },
    Vector {
        _handler: UART3_ERR,
    },
    Vector { _handler: ADC0 },
    Vector { _handler: CMP0 },
    Vector { _handler: CMP1 },
    Vector { _handler: FTM0 },
    Vector { _handler: FTM1 },
    Vector { _handler: FTM2 },
    Vector { _handler: CMT },
    Vector { _handler: RTC },
    Vector {
        _handler: RTC_SECONDS,
    },
    Vector { _handler: PIT0 },
    Vector { _handler: PIT1 },
    Vector { _handler: PIT2 },
    Vector { _handler: PIT3 },
    Vector { _handler: PDB0 },
    Vector { _handler: USB0 },
    Vector { _handler: USBDCD },
    Vector { _reserved: 0 },
    Vector { _handler: DAC0 },
    Vector { _reserved: 0 },
    Vector { _handler: LPTMR0 },
    Vector { _handler: PORTA },
    Vector { _handler: PORTB },
    Vector { _handler: PORTC },
    Vector { _handler: PORTD },
    Vector { _handler: PORTE },
    Vector { _reserved: 0 },
    Vector { _handler: SPI2 },
    Vector {
        _handler: UART4_RX_TX,
    },
    Vector {
        _handler: UART4_ERR,
    },
    Vector {
        _handler: UART5_RX_TX,
    },
    Vector {
        _handler: UART5_ERR,
    },
    Vector { _reserved: 0 },
    Vector { _handler: FTM3 },
    Vector { _reserved: 0 },
    Vector { _handler: ADC1 },
    Vector { _handler: I2C2 },
];


#[entry]
fn main() -> ! {
    // Check out the 'Cortex-M Peripherals' singleton.
    let mut cm_p = cortex_m::Peripherals::take().unwrap();

    // Set up the SysTick peripheral.
    let mut syst = cm_p.SYST;
    syst.set_clock_source(SystClkSource::Core);
    syst.set_reload(1000_000);
    syst.enable_counter();
    syst.clear_current();

    // Main loop.
    loop {
        while !syst.has_wrapped() {}
    }
}
