# tcrash.py
import threading
import stackless
import time

class vesin(object):
    def __init__(self, args=()):
        self.e1 = threading.Event()
        self.done = False
        self.t = None
        self.args = args
        self.thread = threading.Thread(target=self.threadfunc)
        self.thread.start() 

    def setup(self, args):
        # setup from main thread
        self.e1.wait()
        self.t(*args)  # crashes here when allocating c stack

    def join(self):
        self.thread.join()

    def threadfunc(self):
        self.t = stackless.tasklet(self.task)
        if self.args:
            self.t(*self.args) # setup from the worker thread
        self.e1.set()  #that the tasklet has been created
        # schedule until tasklet is done
        while not self.done:
            time.sleep(0.001)
            stackless.run()

    def task(self, *args):
        print "got args", args
        self.done = True


def testok():
    v = vesin((1,2,3))  #setup done on target thread
    v.join()


def testfail():
    v = vesin()
    v.setup((1,2,3))  #setup done on this thread
    v.join()


testok()
testfail()

