# insert your copyright here

# see the URL below for information on how to write OpenStudio measures
# http://nrel.github.io/OpenStudio-user-documentation/reference/measure_writing_guide/

# start the measure
class ExamplePathArgument < OpenStudio::Measure::ModelMeasure
  # human readable name
  def name
    # Measure name should be the title case of the class name.
    return 'ExamplePathArgument'
  end

  # human readable description
  def description
    return 'A measure that has a Path argument'
  end

  # human readable description of modeling approach
  def modeler_description
    return 'Testing https://github.com/openstudiocoalition/OpenStudioApplication/issues/263'
  end

  # define the arguments that the user will input
  def arguments(model)
    args = OpenStudio::Measure::OSArgumentVector.new

    isRead = false
    extension = "CSV (*.csv);;Excel (*.xls *.xlsx);;All Files (*)"
    required = true
    modelDependent = false
    output_path = OpenStudio::Measure::OSArgument.makePathArgument('output_path', isRead, extension, required, modelDependent)
    output_path.setDisplayName('Output Path on Disk')
    args << output_path

    return args
  end

  # define what happens when the measure is run
  def run(model, runner, user_arguments)
    super(model, runner, user_arguments)  # Do **NOT** remove this line

    # use the built-in error checking
    if !runner.validateUserArguments(arguments(model), user_arguments)
      return false
    end

    # assign the user inputs to variables
    output_path = runner.getPathArgumentValue('output_path', user_arguments)

    puts "output_path=#{output_path}"

    File.write(output_path.to_s, "hello")

    # report final condition of model
    runner.registerFinalCondition("The output path is #{output_path}")

    return true
  end
end

# register the measure to be used by the application
ExamplePathArgument.new.registerWithApplication
