using System;
using Microsoft.Maui.Controls;
using System.Linq;
using System.Collections.ObjectModel;




namespace EmptyViewSample
{
    public partial class OptionsPage : ContentPage
    {
        private CollectionViewViewModel _viewModel;

        public OptionsPage(CollectionViewViewModel viewModel)
        {
            InitializeComponent();
            _viewModel = viewModel;
            BindingContext = _viewModel;
        }

        private void ApplyButton_Clicked(object sender, EventArgs e)
        {
            Navigation.PopAsync();
        }

        private void OnEmptyViewChanged(object sender, CheckedChangedEventArgs e)
        {
            if (EmptyViewNone.IsChecked)
            {
                _viewModel.EmptyView = null;
            }
            else if (EmptyViewString.IsChecked)
            {
                _viewModel.EmptyView = "No Items Available(String)";
            }
            else if (EmptyViewGrid.IsChecked)
            {
                Grid grid = new Grid
                {
                    BackgroundColor = Colors.LightGray,
                    Padding = new Thickness(10),
                };
                grid.Children.Add(new Label
                {
                    Text = "No Items Available(Grid View)",
                    HorizontalOptions = LayoutOptions.Center,
                    VerticalOptions = LayoutOptions.Center,
                    TextColor = Colors.Blue
                });
                _viewModel.EmptyView = grid;
            }
            else if (EmptyViewCustomSize.IsChecked)
            {
                Frame customView = new Frame
                {
                    BackgroundColor = Colors.LightBlue,
                    HeightRequest = 200,
                    AutomationId = "TestLabel",
                    WidthRequest = 200,
                  
                    BorderColor = Colors.Green,
                    HorizontalOptions = LayoutOptions.Center,
                    VerticalOptions = LayoutOptions.Center,
                    Content = new Label
                    {
                        Text = "Custom Empty View (Sized)",
                        HorizontalOptions = LayoutOptions.Center,
                        VerticalOptions = LayoutOptions.Center,
                    }
                };
                _viewModel.EmptyView = customView;
            }
        }

        private void OnHeaderChanged(object sender, CheckedChangedEventArgs e)
        {
            if (HeaderNone.IsChecked)
            {
                _viewModel.Header = null;
            }
            else if (HeaderString.IsChecked)
            {
                _viewModel.Header = "CollectionView Header(String)";
            }
            else if (HeaderGrid.IsChecked)
            {
                Grid grid = new Grid
                {
                    BackgroundColor = Colors.LightGray,
                    Padding = new Thickness(10)
                };
                grid.Children.Add(new Label
                {
                    Text = "CollectionView Header(Grid View)",
                    HorizontalOptions = LayoutOptions.Center,
                    TextColor = Colors.Blue
                });
                _viewModel.Header = grid;
            }
        }

        private void OnFooterChanged(object sender, CheckedChangedEventArgs e)
        {
            if (FooterNone.IsChecked)
            {
                _viewModel.Footer = null;
            }
            else if (FooterString.IsChecked)
            {
                _viewModel.Footer = "CollectionView Footer(String)";
            }
            else if (FooterGrid.IsChecked)
            {
                Grid grid = new Grid
                {
                    BackgroundColor = Colors.LightGray,
                    Padding = new Thickness(10)
                };
                grid.Children.Add(new Label
                {
                    Text = "CollectionView Footer(Grid View)",
                    HorizontalOptions = LayoutOptions.Center,
                    TextColor = Colors.Red
                });
                _viewModel.Footer = grid;
            }

        }

        private void OnEmptyViewTemplateChanged(object sender, CheckedChangedEventArgs e)
        {
            if (EmptyViewTemplateNone.IsChecked)
            {
                _viewModel.EmptyViewTemplate = null;
            }
            else if (EmptyViewTemplateGrid.IsChecked)
            {
                _viewModel.EmptyViewTemplate = new DataTemplate(() =>
                {
                    Grid grid = new Grid
                    {
                        BackgroundColor = Colors.LightGray,
                        Padding = new Thickness(10),
                    };
                    grid.Children.Add(new Label
                    {
                        Text = "No Template Items Available(Grid View)",
                        HorizontalOptions = LayoutOptions.Center,
                        VerticalOptions = LayoutOptions.Center,
                        TextColor = Colors.Blue
                    });
                    return grid;
                });
            }
            else if (EmptyViewTemplateCustomSize.IsChecked)
            {
                _viewModel.EmptyViewTemplate = new DataTemplate(() =>
                {
                    Frame customView = new Frame
                    {
                        BackgroundColor = Colors.LightBlue,
                        HeightRequest = 200,
                        BorderColor = Colors.Green,
                       
                        AutomationId = "TestLabel",
                        WidthRequest = 200,
                        HorizontalOptions = LayoutOptions.Center,
                        VerticalOptions = LayoutOptions.Center,
                        Content = new Label
                        {
                            Text = "Custom EmptyTemplate View (Sized)",
                            HorizontalOptions = LayoutOptions.Center,
                            VerticalOptions = LayoutOptions.Center,
                        }
                    };
                    return customView;
                });
            }
        }
        


        private void OnHeaderTemplateChanged(object sender, CheckedChangedEventArgs e)
        {
            if (HeaderTemplateNone.IsChecked)
            {
                _viewModel.HeaderTemplate = null;
            }
            else if (HeaderTemplateGrid.IsChecked)
            {
                _viewModel.HeaderTemplate = new DataTemplate(() =>
                {
                    Grid grid = new Grid
                    {
                        BackgroundColor = Colors.LightGray,
                        Padding = new Thickness(10)
                    };
                    grid.Children.Add(new Label
                    {
                        Text = "Header Template(Grid View)",
                        FontAttributes = FontAttributes.Bold,
                        HorizontalOptions = LayoutOptions.Center,
                        TextColor = Colors.Blue
                    });
                    return grid;
                });
            }
        }

        private void OnFooterTemplateChanged(object sender, CheckedChangedEventArgs e)
        {
            if (FooterTemplateNone.IsChecked)
            {
                _viewModel.FooterTemplate = null;
            }
            else if (FooterTemplateGrid.IsChecked)
            {
                _viewModel.FooterTemplate = new DataTemplate(() =>
                {
                    Grid grid = new Grid
                    {
                        BackgroundColor = Colors.LightGray,
                        Padding = new Thickness(10)
                    };
                    grid.Children.Add(new Label
                    {
                        Text = "Footer Template(Grid View)",
                        FontAttributes = FontAttributes.Bold,
                        HorizontalOptions = LayoutOptions.Center,
                        TextColor = Colors.Green
                    });
                    return grid;
                });
            }
        }



        private void OnItemsSourceChanged(object sender, CheckedChangedEventArgs e)
        {
            if (!(sender is RadioButton radioButton) || !e.Value)
                return;

            if (radioButton == ItemsSourceList)
                _viewModel.ItemsSourceType = ItemsSourceType.ListT;

            else if (radioButton == ItemsSourceNone)
                _viewModel.ItemsSourceType = ItemsSourceType.None;
        }
    }
}
