using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Runtime.CompilerServices;
using System.Linq;
using Microsoft.Maui.Controls;

namespace EmptyViewSample
{
     
    public enum ItemsSourceType
    {
        None,
        ListT,
         
    }

    public class CollectionViewViewModel : INotifyPropertyChanged
    {
        private object _header;
        private object _footer;
        private object _emptyView;
        private DataTemplate _headerTemplate;
        private DataTemplate _footerTemplate;
        private DataTemplate _emptyViewTemplate;
        private ItemsSourceType _itemsSourceType = ItemsSourceType.None;

        public event PropertyChangedEventHandler PropertyChanged;

        private List<ItemModel> _flatList;
        public CollectionViewViewModel()
        {
            LoadItems();
        }
 
        private void LoadItems()
        {
            _flatList = new List<ItemModel>
            {
                new ItemModel { Name = "Item 1", Description = "Description 1" },
                new ItemModel { Name = "Item 2", Description = "Description 2" },
                new ItemModel { Name = "Item 3", Description = "Description 3" }
            };
        }

       
        public DataTemplate HeaderTemplate
        {
            get => _headerTemplate;
            set { _headerTemplate = value; OnPropertyChanged(); }
        }

        public DataTemplate FooterTemplate
        {
            get => _footerTemplate;
            set { _footerTemplate = value; OnPropertyChanged(); }
        }
 
        public ItemsSourceType ItemsSourceType
        {
            get => _itemsSourceType;
            set
            {
                if (_itemsSourceType != value)
                {
                    _itemsSourceType = value;
                    OnPropertyChanged();
                    OnPropertyChanged(nameof(ItemsSource));
                }
            }
        }

               

        public object Header
        {
            get => _header;
            set
            {
                _header = value;
                OnPropertyChanged();
            }
        }

        public object Footer
        {
            get => _footer;
            set
            {
                _footer = value;
                OnPropertyChanged();
            }
        }

        public object EmptyView
        {
            get => _emptyView;
            set
            {
                _emptyView = value;
                OnPropertyChanged();
            }
        }

 
        public DataTemplate EmptyViewTemplate
        {
            get => _emptyViewTemplate;
            set
            {
                _emptyViewTemplate = value;
                OnPropertyChanged();
            }
        }

       
        public object ItemsSource
        {
            get
            {
                return ItemsSourceType switch
                {
                    ItemsSourceType.ListT => _flatList,
                    ItemsSourceType.None => null,
                    _ => null
                };
            }
        }
        protected void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }

    public class ItemModel
    {
        public string Name { get; set; }
        public string Description { get; set; }

        public override string ToString()
        {
            if (Name != null && Description != null)
                return $"{Name} - {Description}";
            else if (Name != null)
                return Name;
            else
                return base.ToString();
        }
    }
}
