use bevy::{
    prelude::*,
    window::WindowMode,
};

fn main() {
    App::new()
        .add_plugins((
            DefaultPlugins
        ))
        .add_systems(Startup, setup)
        .run();
}
fn setup(
    mut commands: Commands,
    mut assets: ResMut<AssetServer>,
) {
    let mut projection = OrthographicProjection::default_3d();
    projection.scale = 2.0;
    commands.spawn((
        Camera3d::default(),
         Camera {
            clear_color: Color::srgb(1.0, 0.0, 0.0).into(),
            order: 1,
            hdr: true,
            ..default()
        },
        Transform::from_xyz(0.0, 0.0, 0.0),
        Projection::Orthographic(projection),
    ));
    for x in 0..20 {
        for y in 0..20 {
            let x = (x as f32 - 10.0) * 100.0;
            let y = (y as f32 - 10.0) * 100.0;
            commands.spawn((
                SceneRoot(assets.load(GltfAssetLabel::Scene(0).from_asset("eye.glb"))),
                Transform::from_xyz(x,y, -10.0),
            ));
        }
    }
}
