﻿using Microsoft.Maui.Handlers;

namespace PointerEventMultiWindowBug
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();
        }

        private void NewWindowButton_Clicked(object sender, EventArgs e)
        {
            Application.Current.OpenWindow(new Window(new MainPage()));
        }

        private void PointerGestureRecognizer_PointerEntered(object sender, PointerEventArgs e)
        {
            TheBorder.BackgroundColor = Colors.Lime;
        }

        private void PointerGestureRecognizer_PointerExited(object sender, PointerEventArgs e)
        {
            TheBorder.BackgroundColor = Colors.Red;
        }

        private void TheNativeBorder_Loaded(object sender, EventArgs e)
        {
            // bypass Maui and use winui mouse events
#if WINDOWS
            var handler = (ViewHandler)TheNativeBorder.Handler;
            var nativeView = handler.PlatformView;

            nativeView.PointerEntered += (s, e) =>
            {
                TheNativeBorder.BackgroundColor = Colors.Lime;
            };

            nativeView.PointerExited += (s, e) =>
            {
                TheNativeBorder.BackgroundColor = Colors.Red;
            };

            nativeView.PointerMoved += (s, e) =>
            {
                var pt = e.GetCurrentPoint(nativeView)?.Position ?? default;
                AbsoluteLayout.SetLayoutBounds(NativeEllipse, new(pt.X - 8, pt.Y - 8, 16, 16));
            };

#endif
        }

        private void PointerGestureRecognizer_PointerMoved(object sender, PointerEventArgs e)
        {
            var pt = e.GetPosition(TheBorder).GetValueOrDefault();
            AbsoluteLayout.SetLayoutBounds(Ellipse, new(pt.X - 8, pt.Y - 8, 16, 16));
        }
    }
}
